//=============================================================================
// PTST.
//=============================================================================
class PTST extends ThrownProjectile;

var float	mpBlastRadius;
var float	mpProxRadius;
var float	mpLAMDamage;
var float	mpFuselength;

simulated function Tick(float deltaTime)
{
	local float blinkRate;

	Super.Tick(deltaTime);

	if (bDisabled)
	{
		Skin = Texture'BlackMaskTex';
		return;
	}

	// flash faster as the time expires
	if (fuseLength - time <= 0.75)
		blinkRate = 0.1;
	else if (fuseLength - time <= fuseLength * 0.5)
		blinkRate = 0.3;
	else
		blinkRate = 0.5;

   if ((Level.NetMode == NM_Standalone) || (Role < ROLE_Authority) || (Level.NetMode == NM_ListenServer))
   {
      if (Abs((fuseLength - time)) % blinkRate > blinkRate * 0.5)
         Skin = Texture'BlackMaskTex';
      else
         Skin = Texture'LAM3rdTex1';
   }
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		proxRadius=mpProxRadius;
		Damage=mpLAMDamage;
		fuseLength=mpFuselength;
		bIgnoresNanoDefense=True;
	}
}

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
    local ProjectileGenerator gen;
    //here on the greaselspits
   	gen = Spawn(class'ProjectileGenerator',,, HitLocation, Rotator(HitNormal));
	if (gen != None)
	{
        gen.RemoteRole = ROLE_None;
		gen.checkTime = 0.05;
		gen.frequency = 1.0;
		gen.ejectSpeed = 200.0;
		gen.bRandomEject = True;
		gen.ProjectileClass = class'Markistan.PhosphorBall';
		gen.LifeSpan = 1.0;
	}
}

defaultproperties
{
     mpBlastRadius=512.000000
     mpProxRadius=128.000000
     mpLAMDamage=500.000000
     mpFuselength=1.500000
     proxRadius=128.000000
     blastRadius=256.000000
     DamageType=Flamed
     spawnAmmoClass=Class'Markistan.AmmoPTST'
     ItemName="Precision Toasts Stupid Twits (PTST)"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=200.000000
     MomentumTransfer=50000
     ImpactSound=Sound'DeusExSounds.Weapons.LAMExplode'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     LifeSpan=0.000000
     Mesh=LodMesh'DeusExItems.LAMPickup'
     CollisionRadius=4.300000
     CollisionHeight=3.800000
     Mass=5.000000
     Buoyancy=2.000000
}
